/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.ModelCreatureObj;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelStrider
extends ModelCreatureObj {
    float maxLeg = 0.0f;

    public ModelStrider() {
        this(1.0f);
    }

    public ModelStrider(float shadowSize) {
        this.initModel("strider", LycanitesMobs.modInfo, "entity/strider");
        this.lookHeadScaleX = 0.0f;
        this.lookHeadScaleY = 0.0f;
        this.trophyScale = 0.4f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
        this.bodyIsTrophy = true;
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("armleft")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("armright")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        float walkSwing = 0.15f;
        if (partName.equals("legleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * (distance / 2.0f)));
        }
        if (partName.equals("legright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * (distance / 2.0f)));
        }
        if (partName.equals("legback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            if (partName.equals("armleft")) {
                this.rotate(-25.0f, 0.0f, 0.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(-25.0f, 0.0f, 0.0f);
            }
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).hasPickupEntity() && (partName.equals("armleft") || partName.equals("armright"))) {
            rotX = (float)((double)rotX + 20.0);
        }
        this.angle(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

